package org.maxsite;

/*
* это контролер, он жестко завязан на форму
* */

import javafx.fxml.FXML;
import javafx.scene.control.TextField;

public class Controller extends View {
    // форма: поля ввода
    @FXML private TextField tf1;
    @FXML private TextField tf2;

    // контролер должен знать модель
    // в модели все вычисления и внутренние данные
    private Model model = new Model();

    // нажатите кнопки BtnPlus
    @FXML public void onActionBtnPlus() {
        model.setOp("+");
    }

    // нажатите кнопки BtnMinus
    @FXML public void onActionBtnMinus() {
        model.setOp("-");
    }

    // нажатите кнопки BtnGo - получение результата
    @FXML public void onActionBtnGo() {
        this.go();
    }

    // функция для получения и вывода результата
    private void go(){
        // отдаем модели нужные данные
        model.setNum1(tf1.getText());
        model.setNum2(tf2.getText());

        // вычисляем результат
        model.go();

        // дальше нужно вывести результат
        displayLabel(model.getResult());
    }
}
